/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.discord;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.discord.FormParser;

public abstract class Webhook {
    private static final long newColour = 4042994L;
    private static final long soldColour = 3468102L;
    private static final String pokemonBody = "{\n    \"username\": \"GTS\",\n    \"embeds\": [\n        {\n            \"title\": \"%title%\",\n            \"color\": %colour%,\n            \"thumbnail\": {\n                \"url\": \"https://img.pokemondb.net/sprites/home/%shiny%/%dex%%form%.png\"\n            },\n            \"fields\": [\n                {\n                    \"name\": \"\",\n                    \"value\": \"**Pokemon:** %pokemon%\\n**Seller:** %seller%\\n**Price:** %price%\\n**Types:** %types%\\n**Nature:** %nature%**\\nAbility:** %ability%\"\n                },\n                {\n                    \"name\": \"IVs\",\n                    \"value\": \"**HP:** %hp_iv%\\n**Atk:** %atk_iv%\\n**Def:** %def_iv%\\n**SpA:** %spa_iv%\\n**SpD:** %spd_iv%\\n**Spe:** %spe_iv%\"\n                },\n                {\n                    \"name\": \"EVs\",\n                    \"value\": \"**HP:** %hp_ev%\\n**Atk:** %atk_ev%\\n**Def:** %def_ev%\\n**SpA:** %spa_ev%\\n**SpD:** %spd_ev%\\n**Spe:** %spe_ev%\"\n                },\n                {\n                    \"name\": \"Moves\",\n                    \"value\": \"%moves%\"                }\n            ],\n            \"author\": {\n                \"name\": \"GTS\"\n            }\n        }\n    ]\n}";
    private static final String itemBody = "{\n    \"username\": \"GTS\",\n    \"embeds\": [\n        {\n            \"title\": \"%title%\",\n            \"color\": %colour%,\n            \"fields\": [\n                {\n                    \"name\": \"\",\n                    \"value\": \"**Item:** %item%\\n**Seller:** %seller%\\n**Price:** %price%\\n**Amount:** %amount%\"\n                }\n            ],\n            \"author\": {\n                \"name\": \"GTS\"\n            }\n        }\n    ]\n}";

    public static void newListing(Listing listing) {
        if (listing.isPokemon()) {
            PokemonListing pokemonListing = (PokemonListing)listing;
            StringBuilder types = new StringBuilder();
            pokemonListing.getListing().getTypes().forEach(e -> types.append(e.getDisplayName().getString()).append(" "));
            StringBuilder moves = new StringBuilder();
            pokemonListing.getListing().getMoveSet().getMoves().forEach(e -> moves.append(e.getDisplayName().getString()).append(", "));
            moves.replace(moves.length() - 2, moves.length(), "");
            Webhook.sendPost(pokemonBody.replaceAll("%title%", "New Listing").replaceAll("%colour%", String.valueOf(4042994L)).replaceAll("%dex%", pokemonListing.getListing().getSpecies().getTranslatedName().getString().toLowerCase(Locale.ROOT)).replaceAll("%shiny%", pokemonListing.getListing().getShiny() ? "shiny" : "normal").replaceAll("%form%", FormParser.parseForm(pokemonListing.getListing().getForm().getName())).replaceAll("%pokemon%", pokemonListing.getListing().getSpecies().getTranslatedName().getString()).replaceAll("%seller%", pokemonListing.getSellerName()).replaceAll("%price%", pokemonListing.getPriceAsString()).replaceAll("%types%", types.toString().trim()).replaceAll("%nature%", class_2561.method_43471((String)pokemonListing.getListing().getNature().getDisplayName()).getString()).replaceAll("%ability%", class_2561.method_43471((String)pokemonListing.getListing().getAbility().getDisplayName()).getString()).replaceAll("%hp_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.HP) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.HP).toString()).replaceAll("%atk_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.ATTACK) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.ATTACK).toString()).replaceAll("%def_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.DEFENCE) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.DEFENCE).toString()).replaceAll("%spa_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_ATTACK) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_ATTACK).toString()).replaceAll("%spd_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_DEFENCE) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_DEFENCE).toString()).replaceAll("%spe_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPEED) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPEED).toString()).replaceAll("%hp_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.HP) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.HP).toString()).replaceAll("%atk_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.ATTACK) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.ATTACK).toString()).replaceAll("%def_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.DEFENCE) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.DEFENCE).toString()).replaceAll("%spa_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_ATTACK) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_ATTACK).toString()).replaceAll("%spd_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_DEFENCE) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_DEFENCE).toString()).replaceAll("%spe_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPEED) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPEED).toString()).replaceAll("%moves%", moves.toString().trim()));
        } else {
            ItemListing itemListing = (ItemListing)listing;
            Webhook.sendPost(itemBody.replaceAll("%title%", "New Listing").replaceAll("%colour%", String.valueOf(4042994L)).replaceAll("%item%", itemListing.getListing().method_7954().getString().replaceAll("\\[", "").replaceAll("\\]", "")).replaceAll("%seller%", itemListing.getSellerName()).replaceAll("%price%", itemListing.getPriceAsString()).replaceAll("%amount%", String.valueOf(itemListing.getListing().method_7947())));
        }
    }

    public static void soldListing(Listing listing) {
        if (listing.isPokemon()) {
            PokemonListing pokemonListing = (PokemonListing)listing;
            StringBuilder types = new StringBuilder();
            pokemonListing.getListing().getTypes().forEach(e -> types.append(e.getDisplayName().getString()).append(" "));
            StringBuilder moves = new StringBuilder();
            pokemonListing.getListing().getMoveSet().getMoves().forEach(e -> moves.append(e.getDisplayName().getString()).append(", "));
            moves.replace(moves.length() - 2, moves.length(), "");
            Webhook.sendPost(pokemonBody.replaceAll("%title%", "Sold Listing").replaceAll("%colour%", String.valueOf(3468102L)).replaceAll("%dex%", pokemonListing.getListing().getSpecies().getTranslatedName().getString().toLowerCase(Locale.ROOT)).replaceAll("%shiny%", pokemonListing.getListing().getShiny() ? "shiny" : "normal").replaceAll("%form%", FormParser.parseForm(pokemonListing.getListing().getForm().getName())).replaceAll("%pokemon%", pokemonListing.getListing().getSpecies().getTranslatedName().getString()).replaceAll("%seller%", pokemonListing.getSellerName()).replaceAll("%price%", pokemonListing.getPriceAsString()).replaceAll("%types%", types.toString().trim()).replaceAll("%nature%", class_2561.method_43471((String)pokemonListing.getListing().getNature().getDisplayName()).getString()).replaceAll("%ability%", class_2561.method_43471((String)pokemonListing.getListing().getAbility().getDisplayName()).getString()).replaceAll("%hp_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.HP) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.HP).toString()).replaceAll("%atk_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.ATTACK) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.ATTACK).toString()).replaceAll("%def_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.DEFENCE) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.DEFENCE).toString()).replaceAll("%spa_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_ATTACK) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_ATTACK).toString()).replaceAll("%spd_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_DEFENCE) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPECIAL_DEFENCE).toString()).replaceAll("%spe_iv%", pokemonListing.getListing().getIvs().get((Stat)Stats.SPEED) == null ? "0" : pokemonListing.getListing().getIvs().get((Stat)Stats.SPEED).toString()).replaceAll("%hp_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.HP) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.HP).toString()).replaceAll("%atk_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.ATTACK) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.ATTACK).toString()).replaceAll("%def_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.DEFENCE) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.DEFENCE).toString()).replaceAll("%spa_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_ATTACK) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_ATTACK).toString()).replaceAll("%spd_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_DEFENCE) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPECIAL_DEFENCE).toString()).replaceAll("%spe_ev%", pokemonListing.getListing().getEvs().get((Stat)Stats.SPEED) == null ? "0" : pokemonListing.getListing().getEvs().get((Stat)Stats.SPEED).toString()).replaceAll("%moves%", moves.toString().trim()));
        } else {
            ItemListing itemListing = (ItemListing)listing;
            Webhook.sendPost(itemBody.replaceAll("%title%", "Sold Listing").replaceAll("%colour%", String.valueOf(3468102L)).replaceAll("%item%", itemListing.getListing().method_7954().getString().replaceAll("\\[", "").replaceAll("\\]", "")).replaceAll("%seller%", itemListing.getSellerName()).replaceAll("%price%", itemListing.getPriceAsString()).replaceAll("%amount%", String.valueOf(itemListing.getListing().method_7947())));
        }
    }

    private static void sendPost(String body) {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        CompletableFuture<HttpResponse<String>> response = client.sendAsync(request = HttpRequest.newBuilder().uri(URI.create(Gts.config.getDiscord().getUrl())).POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").build(), HttpResponse.BodyHandlers.ofString());
        HttpResponse<String> responseBody = response.join();
        if (responseBody.statusCode() != 204) {
            Gts.LOGGER.error("Could not send discord webhook. Error: " + responseBody.body());
        }
    }
}

